package ru.yandex.partner.core.entity.user.multistate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.libs.multistate.action.ActionCheck;
import ru.yandex.partner.libs.multistate.action.ActionCheckId;
import ru.yandex.partner.libs.multistate.action.ActionCheckService;

@Service
@ParametersAreNonnullByDefault
public class UserActionChecksService implements ActionCheckService<User> {
    private final CanChangeRequisitesCheck canChangeRequisitesCheck;

    public UserActionChecksService(CanChangeRequisitesCheck canChangeRequisitesCheck) {
        this.canChangeRequisitesCheck = canChangeRequisitesCheck;
    }

    @Override
    public ActionCheck<User> getActionCheck(ActionCheckId id) {
        if (id instanceof UserActionCheck userActionCheck) {
            //noinspection SwitchStatementWithTooFewBranches
            return switch (userActionCheck) {
                case CAN_CHANGE_REQUISITES -> new ActionCheck<User>(
                        canChangeRequisitesCheck::check,
                        canChangeRequisitesCheck.getRequiredProperties());

                //noinspection UnnecessaryDefault
                default -> throw new IllegalArgumentException(String.format("Action check with id '%s' not found", id));
            };
        }
        throw new IllegalArgumentException(String.format("Action check with id '%s' not found", id));
    }

    public enum UserActionCheck implements ActionCheckId {
        CAN_CHANGE_REQUISITES
    }
}
