package ru.yandex.partner.core.entity.user.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.dbschema.partner.tables.UserAdfox;

@Repository
@ParametersAreNonnullByDefault
public class UserAdfoxRepository {
    private final DSLContext dslContext;

    public UserAdfoxRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public List<Long> getAdfoxId(long userId) {
        return dslContext.select(UserAdfox.USER_ADFOX.ADFOX_ID)
                .from(UserAdfox.USER_ADFOX)
                .where(UserAdfox.USER_ADFOX.USER_ID.eq(userId))
                .fetch(UserAdfox.USER_ADFOX.ADFOX_ID);
    }

}
