package ru.yandex.partner.core.entity.user.repository;

import java.util.Iterator;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.configuration.DslContextProviderStub;
import ru.yandex.partner.core.entity.user.container.UserRepositoryContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportFacade;
import ru.yandex.partner.core.multitype.repository.PartnerModifyRepository;
import ru.yandex.partner.core.multitype.repository.relation.Id;
import ru.yandex.partner.core.service.dbutil.DbValuesGenerator;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.partner.core.service.dbutil.DbValuesGenerator.longValues;
import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

@Repository
@ParametersAreNonnullByDefault
public class UserModifyRepository extends PartnerModifyRepository<BaseUser, BaseUser, UserRepositoryContainer,
        UserRepositoryContainer> {
    private final DbValuesGenerator dbValuesGenerator;

    @Autowired
    public UserModifyRepository(DSLContext dslContext, UserRepositoryTypeSupportFacade typeSupportFacade,
                                UserTypedRepository typedRepository,
                                DbValuesGenerator dbValuesGenerator) {
        super(
                new DslContextProviderStub(dslContext),
                typeSupportFacade,
                typedRepository,
                Id.column(USERS.ID)
        );
        this.dbValuesGenerator = dbValuesGenerator;
    }

    @Override
    protected void generateIds(UserRepositoryContainer addContainer, List<? extends BaseUser> models) {
        Iterator<Long> userIds = longValues(
                dbValuesGenerator.generateValues(
                        USERS,
                        USERS.ID,
                        mapList(models, ModelWithId::getId))
        ).iterator();
        models.forEach(user -> user.setId(userIds.next()));
    }

    @Override
    protected Table<?> getLockTable() {
        return USERS;
    }
}
