package ru.yandex.partner.core.entity.user.repository;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.filter.ConditionFilter;
import ru.yandex.partner.core.entity.user.container.UserRepositoryContainer;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.filter.UserModelFilterContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.repository.filter.UserFilterFactory;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportFacade;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.multitype.repository.PartnerTypedRepository;

import static ru.yandex.partner.dbschema.partner.Tables.USERS;

@Repository
@ParametersAreNonnullByDefault
public class UserTypedRepository
        extends PartnerTypedRepository<BaseUser, Long, UserRepositoryContainer, UserRepositoryContainer> {

    @Autowired
    public UserTypedRepository(UserRepositoryTypeSupportFacade typeSupportFacade,
                               UserModelFilterContainer modelFilterContainer,
                               DSLContext dslContext) {
        super(dslContext, typeSupportFacade, modelFilterContainer);
    }

    @Override
    protected ConditionFilter getIdFilter(Collection<Long> modelIds) {
        return UserFilterFactory.userIdsFilter(modelIds);
    }

    @Override
    protected Table<?> getBaseTable() {
        return USERS;
    }


    public <S extends User> Long getUsersCountByCondition(CoreFilterNode<? super S> coreFilterNode, Class<S> clazz) {
        SelectQuery<Record1<Integer>> query = getSelectCountQuery(this.dslContext, clazz);
        applyFilterToQuery(clazz, coreFilterNode, query);
        return query.fetchSingleInto(Long.class);
    }

    @Override
    protected <S extends BaseUser> CoreFilterNode<S> getCoreFilterNodeById(Collection<Long> ids) {
        return CoreFilterNode.in(UserFilters.ID, ids);
    }

    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return User.ID;
    }


}
