package ru.yandex.partner.core.entity.user.repository.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.multitype.repository.filter.ConditionFilter;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.dbschema.partner.Tables.USERS;

@ParametersAreNonnullByDefault
public class UserFilterFactory {
    private UserFilterFactory() {
    }

    public static ConditionFilter userIdsFilter(Collection<Long> userIds) {
        return whereInFilter(USERS.ID, userIds);
    }
}
