package ru.yandex.partner.core.entity.user.repository.type;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.container.UserRepositoryContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

import static ru.yandex.partner.core.entity.user.service.UserUpdateOperationConstants.USER_TYPE_SUPPORT_CLASS_WHITE_LIST;

@Component
@ParametersAreNonnullByDefault
public class UserRepositoryTypeSupportFacade extends PartnerRepositoryTypeSupportFacade<BaseUser, Long,
        UserRepositoryContainer, UserRepositoryContainer> {
    @Autowired
    public UserRepositoryTypeSupportFacade(
            List<UserRepositoryTypeSupport<? extends BaseUser>> typeSupports) {
        super(typeSupports, User::new, USER_TYPE_SUPPORT_CLASS_WHITE_LIST);
    }
//    Пример как сделано в campaings с вызовом нужного конструктора по типу
//    public UserRepositoryTypeSupportFacade(
//            List<UserRepositoryTypeSupport<? extends BaseUser>> typeSupports) {
//        super(typeSupports, Map.of(
//                CampaignType.TEXT, TextCampaign::new,
//                CampaignType.PERFORMANCE, SmartCampaign::new,
//                CampaignType.CONTENT_PROMOTION, ContentPromotionCampaign::new,
//                CampaignType.CPM_PRICE, CpmPriceCampaign::new,
//                CampaignType.INTERNAL_AUTOBUDGET, InternalAutobudgetCampaign::new,
//                CampaignType.WALLET, WalletTypedCampaign::new,
//                CampaignType.CPM_BANNER, CpmBannerCampaign::new,
//                CampaignType.CPM_YNDX_FRONTPAGE, CpmYndxFrontpageCampaign::new,
//                CampaignType.DYNAMIC, DynamicCampaign::new,
//                CampaignType.BILLING_AGGREGATE, BillingAggregateCampaign::new
//        ), singleton(CAMPAIGNS.TYPE));
//    }

    @Override
    protected Long getModelType(Record record) {
        return 0L;
    }
//    Пример как сделано в campaings определение типа
//    @Override
//    protected CampaignType getModelType(Record record) {
//        return CampaignType.fromSource(record.get(CAMPAIGNS.TYPE, CampaignsType.class));
//    }

}
