package ru.yandex.partner.core.entity.user.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.user.repository.UserAdfoxRepository;

@Service
@ParametersAreNonnullByDefault
public class UserAdfoxService {

    private final UserAdfoxRepository userAdfoxRepository;

    public UserAdfoxService(UserAdfoxRepository userAdfoxRepository) {
        this.userAdfoxRepository = userAdfoxRepository;
    }

    public boolean hasAdfoxAccount(long userId) {
        List<Long> adfoxIds = userAdfoxRepository.getAdfoxId(userId);
        return adfoxIds != null && !adfoxIds.isEmpty();
    }

}
