package ru.yandex.partner.core.entity.user.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.Query;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.repository.UserTypedRepository;
import ru.yandex.partner.core.filter.meta.MetaFilter;

import static ru.yandex.direct.multitype.typesupport.TypeFilteringUtils.filterModelsOfClass;

@Service
@ParametersAreNonnullByDefault
public class UserService implements ModelQueryService<User> {
    private final UserTypedRepository userTypedRepository;

    @Autowired
    public UserService(UserTypedRepository userTypedRepository) {
        this.userTypedRepository = userTypedRepository;
    }

    @Override
    public <S extends User> List<S> findAll(Query<S> opts) {
        return filterModelsOfClass(
                userTypedRepository.getAll(opts),
                opts.getClazz()
        );
    }

    @Override
    public <S extends User> long count(Query<S> opts) {
        return userTypedRepository.getUsersCountByCondition(opts.getFilter(), opts.getClazz());
    }

    @Override
    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return User.ID;
    }

    @Override
    public Class<User> getBaseClass() {
        return User.class;
    }

    @Override
    public <S extends User> MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum) {
        return switch (doActionFilterEnum) {
            case PAGE_ID -> throw new IllegalArgumentException("This service does not support " + doActionFilterEnum);
            case MULTISTATE -> UserFilters.MULTISTATE;
        };
    }
}
