package ru.yandex.partner.core.entity.user.service;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.repository.UserModifyRepository;
import ru.yandex.partner.core.entity.user.repository.UserTypedRepository;
import ru.yandex.partner.core.entity.user.service.type.update.UserUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.user.service.validation.type.UserValidationTypeSupportFacade;
import ru.yandex.partner.core.multitype.service.validation.type.update.EditableFieldValidator;
import ru.yandex.partner.core.operation.factory.UpdateOperationFactory;

@Component
@ParametersAreNonnullByDefault
public class UserUpdateOperationFactory implements UpdateOperationFactory<BaseUser, UserUpdateOperation> {
    private final UserTypedRepository typedRepository;

    private final UserModifyRepository modifyRepository;

    private final UserValidationTypeSupportFacade validationTypeSupportFacade;

    private final UserUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade;

    private final DSLContext dslContext;

    private final EditableFieldValidator<BaseUser> editableFieldValidator;

    @Autowired
    public UserUpdateOperationFactory(UserTypedRepository typedRepository, UserModifyRepository modifyRepository,
                                      UserValidationTypeSupportFacade validationTypeSupportFacade,
                                      UserUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade,
                                      DSLContext dslContext, EditableFieldValidator<BaseUser> editableFieldValidator) {
        this.typedRepository = typedRepository;
        this.modifyRepository = modifyRepository;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.updateOperationTypeSupportFacade = updateOperationTypeSupportFacade;
        this.dslContext = dslContext;
        this.editableFieldValidator = editableFieldValidator;
    }

    public UserUpdateOperation createUpdateOperation(
            Applicability applicability,
            List<ModelChanges<BaseUser>> modelChanges) {
        return new UserUpdateOperation(
                applicability,
                modelChanges,
                dslContext,
                typedRepository,
                modifyRepository,
                updateOperationTypeSupportFacade,
                validationTypeSupportFacade,
                editableFieldValidator);
    }

    public UserUpdateOperation createUpdateOperationWithPreloadedModels(
            Applicability applicability,
            List<ModelChanges<BaseUser>> modelChanges,
            Collection<BaseUser> preloadedModels) {
        return new UserUpdateOperationWithPreloadedModels(
                applicability,
                modelChanges,
                dslContext,
                typedRepository,
                modifyRepository,
                updateOperationTypeSupportFacade,
                validationTypeSupportFacade,
                preloadedModels,
                editableFieldValidator
        );
    }
}
