package ru.yandex.partner.core.entity.user.service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import org.jooq.DSLContext;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.repository.UserModifyRepository;
import ru.yandex.partner.core.entity.user.repository.UserTypedRepository;
import ru.yandex.partner.core.entity.user.service.type.update.UserUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.user.service.validation.type.UserValidationTypeSupportFacade;
import ru.yandex.partner.core.multitype.service.validation.type.update.EditableFieldValidator;

public class UserUpdateOperationWithPreloadedModels extends UserUpdateOperation {

    private final Collection<BaseUser> preloadedModels;

    @SuppressWarnings("checkstyle:parameternumber")
    public UserUpdateOperationWithPreloadedModels(Applicability applicability,
                                                  List<ModelChanges<BaseUser>> modelChanges, DSLContext dslContext,
                                                  UserTypedRepository typedRepository,
                                                  UserModifyRepository modifyRepository,
                                                  UserUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade,
                                                  UserValidationTypeSupportFacade validationTypeSupportFacade,
                                                  Collection<BaseUser> preloadedModels,
                                                  EditableFieldValidator<BaseUser> editableFieldValidator) {
        super(applicability, modelChanges, dslContext, typedRepository, modifyRepository,
                updateOperationTypeSupportFacade, validationTypeSupportFacade, editableFieldValidator);
        this.preloadedModels = preloadedModels;
    }

    @Override
    protected Collection<BaseUser> getModels(@Nonnull Collection<Long> ids) {
        return preloadedModels.stream().filter(model -> ids.contains(model.getId())).collect(Collectors.toList());
    }
}
