package ru.yandex.partner.core.entity.user.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.user.container.UserContainer;
import ru.yandex.partner.core.entity.user.container.UserContainerImpl;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.service.validation.type.UserValidationTypeSupportFacade;

@Service
public class UserValidationService {
    private final UserValidationTypeSupportFacade validationFacade;

    @Autowired
    public UserValidationService(UserValidationTypeSupportFacade validationFacade) {
        this.validationFacade = validationFacade;
    }

    /**
     * Метод принудительно наполняет контейнер данными (словарей и пр.), которые необходимы для валидации
     * В обычном режиме данные подтягиваются перед вызовом метода validate конкретного support'а в фасаде
     *
     * @param container - контейнер с общими данными
     */
    public void forceFillContainerByValidationSupports(UserContainer container) {
        // Вызываем принудительную наливку данных всеми typesupport'ами
        validationFacade.forceFillContainerByValidationSupports(container);
    }

    public ValidationResult<List<? extends BaseUser>, Defect> validate(List<? extends BaseUser> models) {
        return validate(models, UserContainerImpl.create());
    }

    public ValidationResult<List<? extends BaseUser>, Defect> validate(
            List<? extends BaseUser> models, UserContainer container) {
        ValidationResult<List<? extends BaseUser>, Defect> vr = new ValidationResult<>(models);
        validationFacade.validate(container, vr);
        return vr;
    }
}
