package ru.yandex.partner.core.entity.user.service.routing;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@SuppressWarnings("HideUtilityClassConstructor")
public class UserConverters {
    public static String getFullName(String name, String midName, String lastName) {
        String fullName = List.of(name, midName, lastName).stream()
                .filter(Objects::nonNull)
                .map(String::trim)
                .filter(s -> !s.isBlank())
                .collect(Collectors.joining(" "));
        return !fullName.isBlank() ? fullName : "No name";
    }
}
