package ru.yandex.partner.core.entity.user.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.container.UserAdditionalActionsContainer;
import ru.yandex.partner.core.entity.user.container.UserContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportFacade;
import ru.yandex.partner.core.operation.CoreModelAwareUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.operation.CoreModelProvider;

@Component
@ParametersAreNonnullByDefault
public class UserUpdateOperationTypeSupportFacade extends
        CoreModelAwareUpdateOperationTypeSupportFacade<BaseUser, UserContainer,
                UserAdditionalActionsContainer, UserContainer> {

    @Autowired
    public UserUpdateOperationTypeSupportFacade(
            List<UserUpdateOperationTypeSupport<? extends BaseUser>> supports,
            List<CoreModelProvider<? extends BaseUser>> coreModels,
            UserRepositoryTypeSupportFacade repositoryTypeSupportFacade
    ) {
        super(supports, coreModels, repositoryTypeSupportFacade);
    }
}
