package ru.yandex.partner.core.entity.user.service.validation.defects.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.partner.core.entity.user.defect.UserDefectIds;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.defaultDefectProvider;

public class UserDefectPresentationRegistry {
    private UserDefectPresentationRegistry() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableError> userDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(UserDefectIds.CommonUser.INCORRECT_EMAIL,
                        defaultDefectProvider(UserValidationMsg.INCORRECT_EMAIL))
                .register(UserDefectIds.CommonUser.INCORRECT_HAS_MOBILE_MEDIATION,
                        defaultDefectProvider(UserValidationMsg.INCORRECT_HAS_MOBILE_MEDIATION))
                .register(UserDefectIds.CommonUser.INCORRECT_HAS_RSYA,
                        defaultDefectProvider(UserValidationMsg.INCORRECT_HAS_RSYA))
                .build();
    }
}
