package ru.yandex.partner.core.entity.user.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum UserValidationMsg implements GettextMsg {
    INCORRECT_EMAIL(msg("Incorrect E-Mail")),
    INCORRECT_HAS_MOBILE_MEDIATION(msg("Incorrect has_mobile_mediation")),
    INCORRECT_HAS_RSYA(msg("Incorrect has_rsya"));

    private static final String KEYSET_NAME = "lib__Application__Model__Users.pm";

    private final GettextMsgPayload payload;

    UserValidationMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
