package ru.yandex.partner.core.entity.user.service.validation.type;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.partner.core.entity.user.container.UserContainer;
import ru.yandex.partner.core.entity.user.container.UserContainerImpl;
import ru.yandex.partner.core.entity.user.container.UserRepositoryContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class UserValidationTypeSupportFacade
        extends ValidationTypeSupportFacade<BaseUser, UserContainer, UserRepositoryContainer> {

    @Autowired
    public UserValidationTypeSupportFacade(List<UserValidationTypeSupport<? extends BaseUser>> supports,
                                           List<UserRepositoryTypeSupport<? extends BaseUser>> typeSupports,
                                           TypeSupportAffectionHelper<BaseUser> typeSupportAffectionHelper) {
        super(supports, typeSupports, typeSupportAffectionHelper, UserContainerImpl::create);
    }
}
