package ru.yandex.partner.core.entity.user.type.adfoxinfos;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.adfox.model.AdfoxInfo;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.partner.dbschema.partner.tables.UserAdfox.USER_ADFOX;

@Repository
public class UserWithAdfoxInfosRepositoryHelper {
    private final DSLContext dslContext;

    @Autowired
    public UserWithAdfoxInfosRepositoryHelper(DSLContext dslContext) {
        this.dslContext = checkNotNull(dslContext);
    }

    public Map<Long, List<AdfoxInfo>> getAdfoxInfoByUserIds(Collection<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<AdfoxInfo> adfoxInfoList = dslContext.select()
                .from(USER_ADFOX)
                .where(USER_ADFOX.USER_ID.in(userIds))
                .fetch().into(AdfoxInfo.class);

        return StreamEx.of(adfoxInfoList)
                .mapToEntry(AdfoxInfo::getUserId, Function.identity())
                .grouping();
    }
}
