package ru.yandex.partner.core.entity.user.type.adfoxinfos;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.adfox.model.AdfoxInfo;
import ru.yandex.partner.core.entity.user.model.UserWithAdfoxInfos;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithAdfoxInfosAdfoxInfosPropHolder.ADFOX_INFOS;
import static ru.yandex.partner.core.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class UserWithAdfoxInfosRepositoryTypeSupport
        extends AbstractUserRepositoryTypeSupport<UserWithAdfoxInfos>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithAdfoxInfos> {
    private final UserWithAdfoxInfosRepositoryHelper repository;
    private final Set<ModelProperty<? super UserWithAdfoxInfos, ?>> affectedModelProperties;

    @Autowired
    protected UserWithAdfoxInfosRepositoryTypeSupport(DSLContext dslContext,
                                                      UserWithAdfoxInfosRepositoryHelper repository) {
        super(dslContext);
        this.repository = repository;
        this.affectedModelProperties = Set.of(ADFOX_INFOS);
    }

    @Override
    public Set<ModelProperty<? super UserWithAdfoxInfos, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithAdfoxInfos> models) {
        Set<Long> userIds = listToSet(models, UserWithAdfoxInfos::getId);
        Map<Long, List<AdfoxInfo>> adfoxInfosByUsers = repository.getAdfoxInfoByUserIds(userIds);
        models.forEach(user -> user.setAdfoxInfos(adfoxInfosByUsers.get(user.getId())));
    }

    @Override
    public Class<UserWithAdfoxInfos> getTypeClass() {
        return UserWithAdfoxInfos.class;
    }
}
