package ru.yandex.partner.core.entity.user.type.blackboxinfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.UserWithBlackBoxInfo;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxService;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxUserInfo;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithBlackBoxInfoAvatarPropHolder.AVATAR;
import static ru.yandex.partner.core.entity.user.model.prop.UserWithBlackBoxInfoLangPropHolder.LANG;

@Component
@ParametersAreNonnullByDefault
public class UserWithBlackBoxInfoRepositoryTypeSupport extends AbstractUserRepositoryTypeSupport<UserWithBlackBoxInfo>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithBlackBoxInfo> {
    private final BlackboxService blackboxService;
    private final Set<ModelProperty<? super UserWithBlackBoxInfo, ?>> affectedModelProperties;

    @Autowired
    protected UserWithBlackBoxInfoRepositoryTypeSupport(DSLContext dslContext,
                                                        BlackboxService blackboxService) {
        super(dslContext);
        this.blackboxService = blackboxService;
        this.affectedModelProperties = Set.of(AVATAR, LANG);
    }

    @Override
    public Set<ModelProperty<? super UserWithBlackBoxInfo, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithBlackBoxInfo> models) {
        List<Long> userUids = models.stream().map(UserWithBlackBoxInfo::getUid).toList();

        Map<Long, BlackboxUserInfo> userInfoMap = blackboxService.getUserInfos(userUids);
        for (UserWithBlackBoxInfo user : models) {
            BlackboxUserInfo blackboxUserInfo = userInfoMap.get(user.getUid());
            if (blackboxUserInfo != null) {
                user.setAvatar(blackboxUserInfo.getAvatarId());
                user.setLang(blackboxUserInfo.getLanguage());
            }
        }
    }

    @Override
    public Class<UserWithBlackBoxInfo> getTypeClass() {
        return UserWithBlackBoxInfo.class;
    }
}
