package ru.yandex.partner.core.entity.user.type.businessrule;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.UserWithBusinessRules;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithBusinessRulesBusinessRulesActiveCountPropHolder.BUSINESS_RULES_ACTIVE_COUNT;
import static ru.yandex.partner.core.entity.user.model.prop.UserWithBusinessRulesBusinessRulesCountPropHolder.BUSINESS_RULES_COUNT;
import static ru.yandex.partner.core.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class  UserWithBusinessRulesCountRepositoryTypeSupport
        extends AbstractUserRepositoryTypeSupport<UserWithBusinessRules>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithBusinessRules> {

    private final UserWithBusinessRulesRepositoryHelper repository;
    private final Set<ModelProperty<? super UserWithBusinessRules, ?>> affectedModelProperties;

    @Autowired
    public UserWithBusinessRulesCountRepositoryTypeSupport(DSLContext dslContext,
                                                           UserWithBusinessRulesRepositoryHelper repository) {
        super(dslContext);
        this.repository = repository;
        this.affectedModelProperties = Set.of(
                BUSINESS_RULES_COUNT,
                BUSINESS_RULES_ACTIVE_COUNT
        );
    }

    @Override
    public Set<ModelProperty<? super UserWithBusinessRules, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithBusinessRules> models) {
        Set<Long> userIds = listToSet(models, UserWithBusinessRules::getId);
        Map<Long, UserWithBusinessRulesRepositoryHelper.BusinessRulesCounts> countMap =
                repository.getBusinessRulesCount(userIds);
        for (UserWithBusinessRules model : models) {
            UserWithBusinessRulesRepositoryHelper.BusinessRulesCounts counts = countMap.get(model.getId());
            if (counts != null) {
                model.setBusinessRulesCount(counts.getAll());
                model.setBusinessRulesActiveCount(counts.getActive());
            }
        }
    }

    @Override
    public Class<UserWithBusinessRules> getTypeClass() {
        return UserWithBusinessRules.class;
    }
}
