package ru.yandex.partner.core.entity.user.type.businessrule;

import java.util.Collection;
import java.util.Map;

import org.jooq.AggregateFunction;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import static ru.yandex.partner.dbschema.partner.tables.BusinessRules.BUSINESS_RULES;

@Repository
public class UserWithBusinessRulesRepositoryHelper {
    private final DSLContext dslContext;

    @Autowired
    public UserWithBusinessRulesRepositoryHelper(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public Map<Long, BusinessRulesCounts> getBusinessRulesCount(Collection<Long> userIds) {
        // TODO get working bit by name
        Long workingBit = 1L;
        return getBusinessRulesAggregated(userIds,
                DSL.count(BUSINESS_RULES.RULE_ID),
                DSL.sum(
                        DSL.when(BUSINESS_RULES.MULTISTATE.bitAnd(workingBit).eq(workingBit), 1)
                                .otherwise(0)
                )
        );
    }

    private Map<Long, BusinessRulesCounts>
    getBusinessRulesAggregated(Collection<Long> userIds,
                               AggregateFunction<? extends Number> allAggregateFunction,
                               AggregateFunction<? extends Number> activeAggregateFunction) {

        return dslContext.select(BUSINESS_RULES.OWNER_ID, allAggregateFunction, activeAggregateFunction)
                .from(BUSINESS_RULES)
                .where(BUSINESS_RULES.OWNER_ID.in(userIds))
                .groupBy(BUSINESS_RULES.OWNER_ID)
                .fetchMap(
                        record -> record.get(BUSINESS_RULES.OWNER_ID).longValue(),
                        record -> new BusinessRulesCounts(
                                record.get(allAggregateFunction).intValue(),
                                record.get(activeAggregateFunction).intValue()
                        )
                );
    }

    public static class BusinessRulesCounts {
        private final int all;
        private final int active;

        public BusinessRulesCounts(int all, int active) {
            this.all = all;
            this.active = active;
        }

        public int getAll() {
            return all;
        }

        public int getActive() {
            return active;
        }
    }
}
