package ru.yandex.partner.core.entity.user.type.common;

import java.util.Collection;
import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.user.model.CommonUser;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.user.service.routing.UserConverters;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.user.UserMultistate;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.convertibleJsonProperty;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonInteger;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonString;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromFields;
import static ru.yandex.partner.core.entity.user.model.prop.BaseUserDeletionDatePropHolder.DELETION_DATE;
import static ru.yandex.partner.core.entity.user.model.prop.BaseUserIdPropHolder.ID;
import static ru.yandex.partner.core.entity.user.model.prop.BaseUserIsDeletedPropHolder.IS_DELETED;
import static ru.yandex.partner.core.entity.user.model.prop.BaseUserUidPropHolder.UID;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserAccountantEmailPropHolder.ACCOUNTANT_EMAIL;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserBlockLightFormEnabledPropHolder.BLOCK_LIGHT_FORM_ENABLED;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserBusinessUnitPropHolder.BUSINESS_UNIT;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserClientIdPropHolder.CLIENT_ID;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserCountryIdPropHolder.COUNTRY_ID;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserCreateDatePropHolder.CREATE_DATE;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserDomainLoginPropHolder.DOMAIN_LOGIN;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserEmailPropHolder.EMAIL;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserFullNamePropHolder.FULL_NAME;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsAdfoxPartnerPropHolder.IS_ADFOX_PARTNER;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsDmLitePropHolder.IS_DM_LITE;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsEfirBloggerPropHolder.IS_EFIR_BLOGGER;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsGamesPropHolder.IS_GAMES;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsMobileMediationPropHolder.IS_MOBILE_MEDIATION;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsTutbyPropHolder.IS_TUTBY;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserIsVideoBloggerPropHolder.IS_VIDEO_BLOGGER;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserLastPayoutPropHolder.LAST_PAYOUT;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserLastnamePropHolder.LASTNAME;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserLoginPropHolder.LOGIN;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserMidnamePropHolder.MIDNAME;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserNamePropHolder.NAME;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserNeedToEmailProcessingPropHolder.NEED_TO_EMAIL_PROCESSING;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserNewsletterPropHolder.NEWSLETTER;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserNoStatMonitoringEmailsPropHolder.NO_STAT_MONITORING_EMAILS;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserPhonePropHolder.PHONE;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserPublicIdPropHolder.PUBLIC_ID;
import static ru.yandex.partner.core.entity.user.model.prop.CommonUserStatusPropHolder.STATUS;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalAdfoxOfferPropHolder.ADFOX_OFFER;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalAllowedDesignAuctionNativeOnlyPropHolder.ALLOWED_DESIGN_AUCTION_NATIVE_ONLY;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalContentBlockEditTemplateAllowedPropHolder.CONTENT_BLOCK_EDIT_TEMPLATE_ALLOWED;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalCooperationFormPropHolder.COOPERATION_FORM;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalCurrencyRatePropHolder.CURRENCY_RATE;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalCurrentCurrencyPropHolder.CURRENT_CURRENCY;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasApprovedPropHolder.HAS_APPROVED;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasCommonOfferPropHolder.HAS_COMMON_OFFER;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasGameOfferPropHolder.HAS_GAME_OFFER;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasMobileMediationPropHolder.HAS_MOBILE_MEDIATION;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasRsyaPropHolder.HAS_RSYA;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalHasTutbyAgreementPropHolder.HAS_TUTBY_AGREEMENT;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalInnPropHolder.INN;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalIsFormDonePropHolder.IS_FORM_DONE;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalModerationReasonPropHolder.MODERATION_REASON;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalNextCurrencyPropHolder.NEXT_CURRENCY;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPaidOfferPropHolder.PAID_OFFER;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPayoneerCurrencyPropHolder.PAYONEER_CURRENCY;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPayoneerPayeeIdPropHolder.PAYONEER_PAYEE_ID;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPayoneerPropHolder.PAYONEER;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPayoneerStepPropHolder.PAYONEER_STEP;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalPayoneerUrlPropHolder.PAYONEER_URL;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalSelfEmployedPropHolder.SELF_EMPLOYED;
import static ru.yandex.partner.core.entity.user.model.prop.UserOptsInternalSelfEmployedRequestIdPropHolder.SELF_EMPLOYED_REQUEST_ID;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.USERS;

@Component
@ParametersAreNonnullByDefault
public class CommonUserRepositoryTypeSupport extends AbstractUserRepositoryTypeSupport<CommonUser>
        implements UserRepositoryTypeSupportWithMapper<CommonUser>, CoreModelProvider<CommonUser> {
    static final CoreModel<CommonUser> DEFAULT_VALUES = CoreModel.forClass(CommonUser.class)
            .property(ModelPropertyDefault.<CommonUser, String>forProperty(MIDNAME)
                    .optional().withDefaultValue(""))
            .build();

    private final JooqMapper<CommonUser> mapper;

    @Autowired
    protected CommonUserRepositoryTypeSupport(DSLContext dslContext, ObjectMapper objectMapper) {
        super(dslContext);
        this.mapper = createJooqMapper(objectMapper);
    }

    private static JooqMapper<CommonUser> createJooqMapper(ObjectMapper objectMapper) {
        return JooqMapperBuilder.<CommonUser>builder()
                .map(property(ID, USERS.ID))
                .map(property(UID, USERS.UID))
                .map(convertibleProperty(IS_DELETED, USERS.IS_DELETED,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(DELETION_DATE, USERS.DELETION_DATE))
                .map(convertibleProperty(User.MULTISTATE, USERS.MULTISTATE,
                        UserMultistate::new,
                        AbstractMultistate::toMultistateValue))
                .map(property(LOGIN, USERS.LOGIN))
                .map(property(NAME, USERS.NAME))
                .map(property(LASTNAME, USERS.LASTNAME))
                .map(property(MIDNAME, USERS.MIDNAME))
                .map(property(EMAIL, USERS.EMAIL))
                .map(property(ACCOUNTANT_EMAIL, USERS.ACCOUNTANT_EMAIL))
                .map(convertibleProperty(NEWSLETTER, USERS.NEWSLETTER, CommonConverters::booleanFromLong,
                        CommonConverters::booleanToLong))
                .map(property(PHONE, USERS.PHONE))
                .map(convertibleProperty(NEED_TO_EMAIL_PROCESSING, USERS.NEED_TO_EMAIL_PROCESSING,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(CLIENT_ID, USERS.CLIENT_ID))
                .map(convertibleProperty(NO_STAT_MONITORING_EMAILS, USERS.NO_STAT_MONITORING_EMAILS,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(COUNTRY_ID, USERS.COUNTRY_ID))
                .map(convertibleProperty(BUSINESS_UNIT, USERS.BUSINESS_UNIT,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_TUTBY, USERS.IS_TUTBY, CommonConverters::booleanFromLong,
                        CommonConverters::booleanToLong))
                .map(convertibleProperty(BLOCK_LIGHT_FORM_ENABLED, USERS.BLOCK_LIGHT_FORM_ENABLED,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_GAMES, USERS.IS_GAMES, CommonConverters::booleanFromLong,
                        CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_MOBILE_MEDIATION, USERS.IS_MOBILE_MEDIATION,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_VIDEO_BLOGGER, USERS.IS_VIDEO_BLOGGER,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_ADFOX_PARTNER, USERS.IS_ADFOX_PARTNER,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_DM_LITE, USERS.IS_DM_LITE,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(IS_EFIR_BLOGGER, USERS.IS_EFIR_BLOGGER,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(DOMAIN_LOGIN, USERS.DOMAIN_LOGIN))
                .readProperty(PUBLIC_ID, fromField(USERS.ID).by(Object::toString))
                .readProperty(FULL_NAME,
                        fromFields(USERS.NAME, USERS.MIDNAME, USERS.LASTNAME).by(UserConverters::getFullName))
                .readProperty(STATUS, fromField(USERS.ID).by(v -> "sinc"))
                .map(property(LAST_PAYOUT, USERS.LAST_PAYOUT))
                .map(property(CREATE_DATE, USERS.CREATE_DATE))
                .map(jsonBooleanToLong(HAS_APPROVED, USERS.OPTS, "has_approved"))
                .map(jsonBooleanToLong(HAS_TUTBY_AGREEMENT, USERS.OPTS, "has_tutby_agreement"))
                .map(jsonBooleanToLong(HAS_COMMON_OFFER, USERS.OPTS, "has_common_offer"))
                .map(jsonBooleanToLong(HAS_MOBILE_MEDIATION, USERS.OPTS, "has_mobile_mediation"))
                .map(jsonBooleanToLong(HAS_RSYA, USERS.OPTS, "has_rsya"))
                .map(jsonBooleanToLong(ADFOX_OFFER, USERS.OPTS, "adfox_offer"))
                .map(jsonBooleanToLong(PAID_OFFER, USERS.OPTS, "paid_offer"))
                .map(jsonBooleanToLong(ALLOWED_DESIGN_AUCTION_NATIVE_ONLY, USERS.OPTS,
                        "allowed_design_auction_native_only"))
                .map(jsonBooleanToLong(CONTENT_BLOCK_EDIT_TEMPLATE_ALLOWED, USERS.OPTS,
                        "content_block_edit_template_allowed"))
                .map(jsonString(INN, USERS.OPTS, "inn"))
                .map(jsonBooleanToLong(IS_FORM_DONE, USERS.OPTS, "is_form_done"))
                .map(jsonString(COOPERATION_FORM, USERS.OPTS, "cooperation_form"))
                .map(jsonInteger(SELF_EMPLOYED, USERS.OPTS, "self_employed"))
                .map(jsonString(SELF_EMPLOYED_REQUEST_ID, USERS.OPTS, "self_employed_request_id"))
                .map(convertibleJsonProperty(
                        MODERATION_REASON,
                        USERS.OPTS,
                        "moderation_reason",
                        value -> CommonConverters.jsonNodeToList(objectMapper, value, Long.class),
                        value -> CommonConverters.listToJsonNode(objectMapper, value)
                ))
                .map(jsonBooleanToLong(PAYONEER, USERS.OPTS, "payoneer"))
                .map(jsonString(PAYONEER_CURRENCY, USERS.OPTS, "payoneer_currency"))
                .map(jsonString(PAYONEER_PAYEE_ID, USERS.OPTS, "payoneer_payee_id"))
                .map(jsonString(PAYONEER_URL, USERS.OPTS, "payoneer_url"))
                .map(jsonInteger(PAYONEER_STEP, USERS.OPTS, "payoneer_step"))
                .map(jsonString(CURRENT_CURRENCY, USERS.OPTS, "current_currency"))
                .map(jsonString(NEXT_CURRENCY, USERS.OPTS, "next_currency"))
                .map(convertibleJsonProperty(
                        CURRENCY_RATE,
                        USERS.OPTS,
                        "currency_rate",
                        CommonConverters::jsonNodeToBigDecimal,
                        CommonConverters::bigDecimalToJsonNode
                ))
                .map(jsonBooleanToLong(HAS_GAME_OFFER, USERS.OPTS, "has_game_offer"))
                .build();
    }

    @Override
    public JooqMapper<CommonUser> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<CommonUser> getTypeClass() {
        return CommonUser.class;
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CommonUser>> appliedChanges) {
        updateHelperAggregator.getOrCreate(USERS.ID).processUpdateAll(mapper, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CommonUser user) {
        insertHelperAggregator.getOrCreate(USERS).add(mapper, user);
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(CommonUser model) {
        return fromModelProperties(
                new HashSet<>(
                        Sets.difference(
                                getJooqMapper().getWritableModelProperties(),
                                CommonUserConstants.EDIT_FORBIDDEN_MODEL_PROPERTIES
                        )
                )
        );
    }

    @Override
    public CoreModel<CommonUser> getCoreModel() {
        return DEFAULT_VALUES;
    }
}
