package ru.yandex.partner.core.entity.user.type.common;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.queue.service.TaskQueueService;
import ru.yandex.partner.core.entity.tasks.convertcpm.ConvertCpmTask;
import ru.yandex.partner.core.entity.user.container.UserContainer;
import ru.yandex.partner.core.entity.user.container.UserRepositoryContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.model.CommonUser;
import ru.yandex.partner.core.entity.user.service.type.update.AbstractUserUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;
import ru.yandex.partner.core.queue.JsonTaskPayload;
import ru.yandex.partner.core.queue.TaskType;

@Component
public class CommonUserUpdateOperationTypeSupport extends AbstractUserUpdateOperationTypeSupport<CommonUser> {
    private final TaskQueueService taskQueueService;

    public CommonUserUpdateOperationTypeSupport(TaskQueueService taskQueueService,
                                                PartnerRepositoryTypeSupportFacade<BaseUser, Long,
            UserRepositoryContainer, UserRepositoryContainer> repositoryFacade) {
        super(repositoryFacade);
        this.taskQueueService = taskQueueService;
    }

    @Override
    public Class<CommonUser> getTypeClass() {
        return CommonUser.class;
    }

    @Override
    public void afterExecution(UserContainer updateContainer, List<AppliedChanges<CommonUser>> appliedChanges) {
        taskQueueService.enqueue(
                appliedChanges.stream()
                        .filter(changes -> changes.getPropertiesForUpdate().contains(CommonUser.NEXT_CURRENCY))
                        .map(AppliedChanges::getModel)
                        .map(user -> new JsonTaskPayload(
                                TaskType.CONVERT_CPM_IN_USER_BLOCKS,
                                new ConvertCpmTask.Payload(
                                        user.getNextCurrency(),
                                        user.getCurrencyRate(),
                                        user.getId()
                                )
                        )).collect(Collectors.toList())
        );
    }
}
