package ru.yandex.partner.core.entity.user.type.common;

import java.util.List;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.user.container.UserContainer;
import ru.yandex.partner.core.entity.user.model.CommonUser;
import ru.yandex.partner.core.entity.user.service.validation.type.AbstractUserValidationTypeSupport;

@Component
public class CommonUserValidationTypeSupport extends AbstractUserValidationTypeSupport<CommonUser> {

    private final Validator<CommonUser, Defect> validator;

    public CommonUserValidationTypeSupport(CommonUserValidatorProvider validatorProvider) {

        this.validator = validatorProvider.validator();
    }

    @Override
    public void fillContainer(UserContainer container, List<CommonUser> users) {
        // Проверяем, если ли необходимые для typesupport'а данные в контейнере
        // Если уже добавлены - не наливаем, просто выходим.
        // Поведение может быть другим, например обновлять данные при каждом вызове
        if (container.getDictionaries().containsKey(CommonUser.class)) {
            return;
        }

        LoadingCache<Long, Object> cache = Caffeine.newBuilder().build(key -> null);

        container.addDictionary(
                CommonUser.class,
                cache
        );
    }

    @Override
    public Class<CommonUser> getTypeClass() {
        return CommonUser.class;
    }

    @Override
    public ValidationResult<List<CommonUser>, Defect> validate(
            UserContainer container,
            ValidationResult<List<CommonUser>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
