package ru.yandex.partner.core.entity.user.type.commonoffer;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.partner.dbschema.partner.tables.CommonOfferAllowedUsers.COMMON_OFFER_ALLOWED_USERS;

@Repository
public class UserWithCommonOfferRepositoryHelper {
    private final DSLContext dslContext;

    @Autowired
    public UserWithCommonOfferRepositoryHelper(DSLContext dslContext) {
        this.dslContext = checkNotNull(dslContext);
    }

    public Map<Long, Long> getCommonOfferByUserIds(Collection<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }

        return dslContext.select(COMMON_OFFER_ALLOWED_USERS.USER_ID, COMMON_OFFER_ALLOWED_USERS.DEADLINE)
                .from(COMMON_OFFER_ALLOWED_USERS)
                .where(COMMON_OFFER_ALLOWED_USERS.DEADLINE.isNotNull())
                .and(COMMON_OFFER_ALLOWED_USERS.USER_ID.in(userIds))
                .fetch()
                .intoMap(
                        record -> record.get(COMMON_OFFER_ALLOWED_USERS.USER_ID).longValue(),
                        record -> calcDaysUntilNow(record.get(COMMON_OFFER_ALLOWED_USERS.DEADLINE))
                );
    }

    private long calcDaysUntilNow(LocalDate localDate) {
        return LocalDate.now().until(localDate, ChronoUnit.DAYS);
    }
}
