package ru.yandex.partner.core.entity.user.type.commonoffer;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.UserWithCommonOffer;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithCommonOfferCommonOfferPropHolder.COMMON_OFFER;
import static ru.yandex.partner.core.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class UserWithCommonOfferRepositoryTypeSupport
        extends AbstractUserRepositoryTypeSupport<UserWithCommonOffer>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithCommonOffer> {
    private final UserWithCommonOfferRepositoryHelper repository;
    private final Set<ModelProperty<? super UserWithCommonOffer, ?>> affectedModelProperties;

    @Autowired
    protected UserWithCommonOfferRepositoryTypeSupport(DSLContext dslContext,
                                                       UserWithCommonOfferRepositoryHelper repository) {
        super(dslContext);
        this.repository = repository;
        this.affectedModelProperties = Set.of(COMMON_OFFER);
    }

    @Override
    public Set<ModelProperty<? super UserWithCommonOffer, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithCommonOffer> models) {
        Set<Long> userIds = listToSet(models, UserWithCommonOffer::getId);
        Map<Long, Long> commonOffersByUsers = repository.getCommonOfferByUserIds(userIds);
        models.forEach(user -> user.setCommonOffer(commonOffersByUsers.get(user.getId())));
    }

    @Override
    public Class<UserWithCommonOffer> getTypeClass() {
        return UserWithCommonOffer.class;
    }
}
