package ru.yandex.partner.core.entity.user.type.cpm;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ActionFactory;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionEdit;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockUpdateOperationFactory;
import ru.yandex.partner.core.entity.notification.UserNotificationsRepository;
import ru.yandex.partner.core.entity.tasks.convertcpm.ConvertCpmTask;
import ru.yandex.partner.core.entity.user.actions.factories.UserEditFactory;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.core.service.mappers.MappersService;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
public class CpmConversionFactory {

    private final BlockService blockService;
    private final UserEditFactory userEditFactory;
    private final MappersService mappersService;
    private final BlockUpdateOperationFactory blockUpdateOperationFactory;
    private final Map<Class<?>, MultistateGraph<? extends BaseBlock, BlockStateFlag>> graphs;
    private final Map<
            Class<?>,
            ModelPayloadActionFactory<? extends BaseBlock, BlockActionEdit<? extends BlockWithMultistate>>
            > actionEditFactories;
    private final ActionPerformer actionPerformer;
    private final UserNotificationsRepository userNotificationsRepository;

    @Autowired
    @SuppressWarnings("parameternumber")
    public CpmConversionFactory(
            BlockService blockService,
            UserEditFactory userEditFactory,
            MappersService mappersService,
            BlockUpdateOperationFactory blockUpdateOperationFactory,
            List<MultistateGraph<? extends BaseBlock, BlockStateFlag>> graphs,
            List<ModelPayloadActionFactory<? extends BaseBlock, BlockActionEdit<? extends BlockWithMultistate>>>
                    actionEditFactories,
            ActionPerformer actionPerformer,
            UserNotificationsRepository userNotificationsRepository
    ) {
        this.blockService = blockService;
        this.userEditFactory = userEditFactory;
        this.mappersService = mappersService;
        this.blockUpdateOperationFactory = blockUpdateOperationFactory;
        this.graphs = graphs.stream()
                .collect(Collectors.toMap(MultistateGraph::getModelClass, Function.identity()));
        this.actionEditFactories = actionEditFactories.stream()
                .collect(Collectors.toMap(ActionFactory::getModelClass, Function.identity()));
        this.actionPerformer = actionPerformer;
        this.userNotificationsRepository = userNotificationsRepository;
    }


    public CpmConversion fromPayload(ConvertCpmTask.Payload payload) {
        return new CpmConversion(
                blockService,
                userEditFactory,
                mappersService,
                blockUpdateOperationFactory,
                graphs,
                actionEditFactories,
                actionPerformer,
                userNotificationsRepository,
                payload.userId(),
                payload.currency(),
                payload.currencyRate()
        );
    }
}
