package ru.yandex.partner.core.entity.user.type.excludeddomains;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.multitype.repository.relation.SimpleListRelationHelper;
import ru.yandex.partner.dbschema.partner.tables.records.UserGlobalExcludedDomainsRecord;

import static ru.yandex.partner.dbschema.partner.tables.UserGlobalExcludedDomains.USER_GLOBAL_EXCLUDED_DOMAINS;

@Repository
public class UserWithExcludedDomainsRepositoryHelper extends
        SimpleListRelationHelper<UserGlobalExcludedDomainsRecord, String> {
    @Autowired
    public UserWithExcludedDomainsRepositoryHelper(DSLContext dslContext) {
        super(
                dslContext,
                USER_GLOBAL_EXCLUDED_DOMAINS,
                USER_GLOBAL_EXCLUDED_DOMAINS.USER_ID,
                UserGlobalExcludedDomainsRecord::getDomain,
                UserGlobalExcludedDomainsRecord::setDomain
        );
    }
}
