package ru.yandex.partner.core.entity.user.type.excludedphones;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import static ru.yandex.partner.dbschema.partner.tables.UserGlobalExcludedPhones.USER_GLOBAL_EXCLUDED_PHONES;

@Repository
public class UserWithExcludedPhonesRepositoryHelper {
    private final DSLContext dslContext;

    @Autowired
    public UserWithExcludedPhonesRepositoryHelper(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public Map<Long, List<String>> getExcludedPhones(Collection<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }

        return dslContext.select(USER_GLOBAL_EXCLUDED_PHONES.USER_ID, USER_GLOBAL_EXCLUDED_PHONES.PHONE)
                .from(USER_GLOBAL_EXCLUDED_PHONES)
                .where(USER_GLOBAL_EXCLUDED_PHONES.USER_ID.in(userIds))
                .fetchGroups(
                        record -> record.get(USER_GLOBAL_EXCLUDED_PHONES.USER_ID).longValue(),
                        record -> record.get(USER_GLOBAL_EXCLUDED_PHONES.PHONE)
                );


    }
}
