package ru.yandex.partner.core.entity.user.type.excludedphones;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.UserWithExcludedPhones;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithExcludedPhonesExcludedPhonesPropHolder.EXCLUDED_PHONES;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.core.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class UserWithExcludedPhonesRepositoryTypeSupport
        extends AbstractUserRepositoryTypeSupport<UserWithExcludedPhones>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithExcludedPhones> {

    private final UserWithExcludedPhonesRepositoryHelper repository;
    private final Set<ModelProperty<? super UserWithExcludedPhones, ?>> affectedModelProperties;

    public UserWithExcludedPhonesRepositoryTypeSupport(DSLContext dslContext,
                                                       UserWithExcludedPhonesRepositoryHelper repository) {
        super(dslContext);
        this.repository = repository;
        this.affectedModelProperties = Set.of(EXCLUDED_PHONES);
    }

    @Override
    public Set<ModelProperty<? super UserWithExcludedPhones, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(UserWithExcludedPhones model) {
        return fromModelProperties(new HashSet<>(affectedModelProperties));
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithExcludedPhones> models) {
        Set<Long> userIds = listToSet(models, UserWithExcludedPhones::getId);
        Map<Long, List<String>> excludedPhonesByUser = repository.getExcludedPhones(userIds);
        models.forEach(userWithExcludedPhones ->
                userWithExcludedPhones.setExcludedPhones(excludedPhonesByUser.get(userWithExcludedPhones.getId())));
    }

    @Override
    public Class<UserWithExcludedPhones> getTypeClass() {
        return UserWithExcludedPhones.class;
    }
}
