package ru.yandex.partner.core.entity.user.type.features;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.multitype.repository.relation.SimpleListRelationHelper;
import ru.yandex.partner.dbschema.partner.tables.records.UserFeaturesRecord;

import static ru.yandex.partner.dbschema.partner.Tables.USER_FEATURES;

@Repository
public class UserWithFeaturesRepositoryHelper extends SimpleListRelationHelper<UserFeaturesRecord, String> {
    @Autowired
    public UserWithFeaturesRepositoryHelper(DSLContext dslContext) {
        super(
                dslContext,
                USER_FEATURES,
                USER_FEATURES.USER_ID,
                UserFeaturesRecord::getFeature,
                UserFeaturesRecord::setFeature
        );
    }
}
