package ru.yandex.partner.core.entity.user.type.notificationcount;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.notification.UserNotificationsRepository;
import ru.yandex.partner.core.entity.user.model.UserWithNotificationCounts;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithNotificationCountsNotificationsCountPropHolder.NOTIFICATIONS_COUNT;
import static ru.yandex.partner.core.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class UserWithNotificationsCountRepositoryTypeSupport
        extends AbstractUserRepositoryTypeSupport<UserWithNotificationCounts>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithNotificationCounts> {
    private final UserNotificationsRepository repository;
    private final Set<ModelProperty<? super UserWithNotificationCounts, ?>> affectedModelProperties;

    @Autowired
    protected UserWithNotificationsCountRepositoryTypeSupport(DSLContext dslContext,
                                                              UserNotificationsRepository repository) {
        super(dslContext);
        this.repository = repository;
        this.affectedModelProperties = Set.of(NOTIFICATIONS_COUNT);
    }

    @Override
    public Set<ModelProperty<? super UserWithNotificationCounts, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithNotificationCounts> models) {
        Set<Long> userIds = listToSet(models, UserWithNotificationCounts::getId);
        Map<Long, Long> notificationsCountByUsers = repository.getNotificationsCountByUserIds(userIds);
        models.forEach(user -> user.setNotificationsCount(notificationsCountByUsers.get(user.getId())));
    }

    @Override
    public Class<UserWithNotificationCounts> getTypeClass() {
        return UserWithNotificationCounts.class;
    }
}
