package ru.yandex.partner.core.entity.user.type.roles;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.user.model.UserWithRoles;
import ru.yandex.partner.core.entity.user.repository.type.AbstractUserRepositoryTypeSupport;
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

import static ru.yandex.partner.core.entity.user.model.prop.UserWithRolesRolesPropHolder.ROLES;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;

@Component
@ParametersAreNonnullByDefault
public class UserWithRolesRepositoryTypeSupport extends AbstractUserRepositoryTypeSupport<UserWithRoles>
        implements UserRepositoryTypeSupportWithoutMapper<UserWithRoles> {
    private final UserRoleService userRoleService;
    private final Set<ModelProperty<? super UserWithRoles, ?>> affectedModelProperties;

    @Autowired
    protected UserWithRolesRepositoryTypeSupport(DSLContext dslContext,
                                                 UserRoleService userRoleService) {
        super(dslContext);
        this.userRoleService = userRoleService;
        this.affectedModelProperties = Set.of(ROLES);
    }

    @Override
    public Set<ModelProperty<? super UserWithRoles, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(UserWithRoles model) {
        return fromModelProperties(new HashSet<>(affectedModelProperties));
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<UserWithRoles> users) {
        List<Long> userIds = users.stream().map(UserWithRoles::getId).collect(Collectors.toList());
        Map<Long, Set<Role>> rolesMap = userRoleService.getUserRolesMap(userIds);
        for (UserWithRoles user : users) {
            Set<Role> roles = rolesMap.get(user.getId());
            user.setRoles(roles);
            user.setIsAssessor(
                    roles.stream().anyMatch(role -> role.getRoleId() == CoreConstants.ASSESSOR_ROLE_ID)
            );
        }
    }

    @Override
    public Class<UserWithRoles> getTypeClass() {
        return UserWithRoles.class;
    }
}
