package ru.yandex.partner.core.entity.utils;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.jooq.Condition;
import org.jooq.TableField;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.entity.PageBlockIds;

public class ConditionUtils {

    private ConditionUtils() {
        // utils
    }

    public static Condition toPageBlockCondition(
            Collection<PageBlockIds> pageBlockIds,
            TableField<?, Long> pageField,
            TableField<?, Long> blockField
    ) {

        return pageBlockIds
                .stream()
                .collect(
                        Collectors.groupingBy(PageBlockIds::getPageId,
                                Collectors.mapping(PageBlockIds::getBlockId, Collectors.toList()))
                )
                .entrySet()
                .stream()
                .map(entry -> pageField.eq(entry.getKey()).and(blockField.in(entry.getValue())))
                .reduce(
                        Condition::or
                ).orElse(DSL.falseCondition());
    }

    public static <K, V> Condition toMapCondition(
            Map<K, ? extends Collection<V>> mapping,
            TableField<?, K> pageField,
            TableField<?, V> blockField) {
        return StreamEx.of(mapping.entrySet())
                .map(entry -> pageField.eq(entry.getKey()).and(blockField.in(entry.getValue())))
                .reduce(
                        Condition::or
                ).orElse(DSL.falseCondition());
    }

}
