package ru.yandex.partner.core.entity.utils

import ru.yandex.partner.core.CoreConstants
import java.math.BigDecimal

object CpmUtils {

    fun getCpmFromTree(dict: Map<Long, CpmNode>, allCpm: Map<Long, BigDecimal>): List<BkCpm> {

        // Начинаю двигатся по мапе. Если я попадая на элемент у которого есть
        // настройка пользователя, то я выставляю указанный cpm. Если настройки
        // нет, то я смотрю, есть ли настройка у родителя и если у родителя есть
        // cpm, то использую этот cpm и у текущего элемент.
        val inFunCache = mutableMapOf<Long, BigDecimal>()

        return dict.entries.mapNotNull { node ->
            if (allCpm.containsKey(node.value.id)) {
                val cpm = allCpm[node.value.id]!!
                inFunCache[node.value.id] = cpm
                BkCpm(
                    id = node.value.id,
                    currency = "RUB",
                    value = (cpm * getMultiplier(cpm).toBigDecimal()).intValueExact()
                )
            } else if (inFunCache.containsKey(node.value.parentId)) {
                val cpm = inFunCache[node.value.parentId]!!
                inFunCache[node.value.id] = cpm
                BkCpm(
                    id = node.value.id,
                    currency = "RUB",
                    value = (cpm * getMultiplier(cpm).toBigDecimal()).intValueExact()
                )
            } else {
                null
            }

        }
    }

    private fun getMultiplier(cpm: BigDecimal): Int {
        return if (cpm > BigDecimal.ZERO) {
            CoreConstants.CPM_MULTIPLIER
        } else {
            1
        }
    }


    data class CpmNode(
        val id: Long,
        val parentId: Long,
        val name: String,
        val level: Long
    )

    data class BkCpm(
        val id: Long,
        val currency: String,
        val value: Int
    )


}
