package ru.yandex.partner.core.entity.utils;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jooq.Field;
import org.jooq.impl.DSL;

@ParametersAreNonnullByDefault
public class DSLUtils {

    private DSLUtils() {
        //Utils
    }

    /**
     * Необходимо для запросов такого вида
     * insert into context_on_site_block_seq(campaign_id, next_block_id)
     * values (1037, 32),(1038, 35)
     * on duplicate key update
     * next_block_id = values(next_block_id);
     */
    public static @NotNull
    <T> Field<T> getValuesStatement(Field<T> field) {
        return DSL.field("values({0})", field.getDataType(), field);
    }

}
