package ru.yandex.partner.core.entity.utils;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@ParametersAreNonnullByDefault
public class TransactionChecker {
    private TransactionChecker() {
        //Utils
    }

    public static void requiredTransaction() {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new NoTransactionException("Transaction method call is not allowed without transaction");
        }
    }

}
