package ru.yandex.partner.core.exceptions;

import com.google.common.collect.Multimap;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.partner.core.action.result.ActionsResult;
import ru.yandex.partner.core.validation.defects.DefectInfoBuilder;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class ValidationException extends RuntimeException {

    private final DefectInfo<Defect> defectInfo;
    private final Multimap<Class<? extends ModelWithId>, Long> affectedIds;
    private final ActionsResult<?> actionsResult;

    public ValidationException(
            GettextMsg comment,
            Multimap<Class<? extends ModelWithId>, Long> affectedIds,
            ActionsResult<?> actionsResult
    ) {
        super("Validation exception \"" + comment + "\" occurred with errors: " + actionsResult.getErrors());
        this.defectInfo = DefectInfoBuilder.createDefectInfo(comment);
        this.affectedIds = affectedIds;
        this.actionsResult = actionsResult;
    }

    public ActionsResult<?> getValidationResult() {
        return actionsResult;
    }

    public Multimap<Class<? extends ModelWithId>, Long> getAffectedIds() {
        return affectedIds;
    }

    public DefectInfo<Defect> getDefectInfo() {
        return this.defectInfo;
    }
}
