package ru.yandex.partner.core.filter;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.container.ModelFilterContainer;

/**
 * Фильтр, который не пропускает ничего.
 * Нужно использовать в сложных комбинациях фильтров
 *
 * @param <M> тип модели
 */
public class AlwaysFalseCoreFilter<M> implements CoreFilter<M> {
    @Override
    public Condition toCondition(Class<M> searchClass, ModelFilterContainer<? super M> filterContainer) {
        return DSL.falseCondition();
    }
}
