package ru.yandex.partner.core.filter;

import java.util.Collection;
import java.util.Objects;

import org.jooq.Condition;

import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class CoreFilterWithValues<M, V> implements CoreFilter<M> {
    private final MetaFilter<M, V> metaFilter;
    private final FilterOperator filterOperator;
    private final Collection<V> values;

    public CoreFilterWithValues(
            MetaFilter<? super M, V> metaFilter,
            FilterOperator filterOperator,
            Collection<V> values
    ) {
        //noinspection unchecked
        this.metaFilter = Objects.requireNonNull((MetaFilter<M, V>) metaFilter);
        this.filterOperator = Objects.requireNonNull(filterOperator);
        this.values = Objects.requireNonNull(values);
    }

    @Override
    public Condition toCondition(Class<M> searchClass, ModelFilterContainer<? super M> filterContainer) {
        return filterContainer.getDbFilter(searchClass, metaFilter)
                .getCondition(filterOperator, values);
    }
    @Override
    public String toString() {
        return metaFilter.getName() + " " + filterOperator.getLabel() + " " + values;
    }
}
