package ru.yandex.partner.core.filter;


import java.util.Collection;
import java.util.List;

import org.jooq.Condition;

import ru.yandex.partner.core.filter.operator.FilterOperator;

/**
 * @param <V> Тип поля в java
 */
public interface Filter<V> {

    Class<V> getValueClass();

    FilterType getFilterType();

    default void check(FilterOperator operator, Collection<?> values) {
        getFilterType().check(operator, values);
    }

    Condition getCondition(FilterOperator operator, Collection<V> value);

    default Condition getCondition(FilterOperator operator, V value) {
        return getCondition(operator, List.of(value));
    }
}
