package ru.yandex.partner.core.filter;

import java.util.Collection;

import ru.yandex.partner.core.filter.checker.BooleanFilterChecker;
import ru.yandex.partner.core.filter.checker.DictionaryFilterChecker;
import ru.yandex.partner.core.filter.checker.MatchChecker;
import ru.yandex.partner.core.filter.checker.MultistateFilterChecker;
import ru.yandex.partner.core.filter.checker.NumberFilterChecker;
import ru.yandex.partner.core.filter.checker.StringFilterChecker;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public enum FilterType {
    NUMBER("number", new NumberFilterChecker(), false),
    PUBLIC_ID("publicid", new NumberFilterChecker(), false),
    BOOLEAN("boolean", new BooleanFilterChecker(), false),
    TEXT("text", new StringFilterChecker(), false),
    DOMAIN_MIRROR("domain_mirror", new StringFilterChecker(), false),
    LOGIN("login", new StringFilterChecker(), false),
    MULTISTATE("multistate", new MultistateFilterChecker(), true),
    DICTIONARY("dictionary", new DictionaryFilterChecker(), true),
    DATE_TIME("date_time", new NumberFilterChecker(), false),
    SUB_FILTER("subfilter", new MatchChecker(), false);

    private final String text;
    private final FilterChecker filterChecker;
    private final boolean isDictionary;

    FilterType(String text, FilterChecker filterChecker, boolean isDictionary) {
        this.text = text;
        this.filterChecker = filterChecker;
        this.isDictionary = isDictionary;
    }

    public String getText() {
        return text;
    }

    public boolean isDictionary() {
        return isDictionary;
    }

    public void check(FilterOperator operator, Collection<?> values) {
        filterChecker.check(operator, values);
    }

}
