package ru.yandex.partner.core.filter;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.container.ModelFilterContainer;

/**
 * Реализация {@link CoreFilter}, которая возвращает нейтральный {@link Condition}
 * Используется в методе {@link CoreFilterNode#neutral()}
 *
 * @param <M> тип модели
 */
public class NeutralCoreFilter<M> implements CoreFilter<M> {
    @Override
    public Condition toCondition(Class<M> searchClass, ModelFilterContainer<? super M> filterContainer) {
        return DSL.noCondition();
    }
}
