package ru.yandex.partner.core.filter.checker;

import java.util.Collection;

import ru.yandex.partner.core.filter.FilterChecker;
import ru.yandex.partner.core.filter.exceptions.FilterIllegalValuesException;
import ru.yandex.partner.core.filter.exceptions.FilterOperatorException;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class BooleanFilterChecker implements FilterChecker {
    @Override
    public void check(FilterOperator operator, Collection<?> values) {
        if (operator != FilterOperator.EQUALS) {
            throw new FilterOperatorException();
        }

        if (values.size() != 1) {
            throw new FilterIllegalValuesException();
        }
    }
}
