package ru.yandex.partner.core.filter.checker;

import java.util.Collection;
import java.util.Set;

import ru.yandex.partner.core.filter.FilterChecker;
import ru.yandex.partner.core.filter.exceptions.FilterIllegalValuesException;
import ru.yandex.partner.core.filter.exceptions.FilterOperatorException;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class MatchChecker implements FilterChecker {

    public MatchChecker() {
    }

    @Override
    public void check(FilterOperator operator, Collection<?> values) {
        if (!Set.of(FilterOperator.MATCH, FilterOperator.NOT_MATCH).contains(operator)) {
            throw new FilterOperatorException();
        }
        if (values.size() != 1) {
            throw new FilterIllegalValuesException();
        }
    }
}
