package ru.yandex.partner.core.filter.checker;

import java.util.Collection;

import ru.yandex.partner.core.filter.FilterChecker;
import ru.yandex.partner.core.filter.exceptions.FilterIllegalValuesException;
import ru.yandex.partner.core.filter.exceptions.FilterOperatorException;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class NumberFilterChecker implements FilterChecker {


    @Override
    public void check(FilterOperator operator, Collection<?> values) {
        boolean valid;
        switch (operator) {
            case GREATER:
            case GREATER_OR_EQUALS:
            case LOWER:
            case LOWER_OR_EQUALS:
                valid = values.size() == 1;
                break;
            case EQUALS:
            case NOT_EQUALS:
            case IN:
            case NOT_IN:
                valid = !values.isEmpty();
                break;
            default:
                throw new FilterOperatorException();
        }

        if (!valid) {
            throw new FilterIllegalValuesException();
        }
    }
}
