package ru.yandex.partner.core.filter.container;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.partner.core.filter.db.DbFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;

public class DefaultModelFilterContainer<M> implements ModelFilterContainer<M> {

    @Override
    public <E extends M, V> DbFilter<E, V> getDbFilter(Class<? super E> searchClass, MetaFilter<E, V> metaFilter) {
        if (metaFilter instanceof DbFilter dbFilter) {
            //noinspection unchecked
            return dbFilter;
        } else {
            throw new NotImplementedException("ModelFilterContainer.getDbFilter. " + metaFilter);
        }
    }

    @Override
    public Class<M> getModelClass() {
        throw new NotImplementedException(this.getClass().getName());
    }
}
