package ru.yandex.partner.core.filter.db;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;

import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MatchMetaFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class AliasDbFilter<M, V> implements DbFilter<M, V> {
    private final MetaFilter<? super M, V> metaFilter;
    private final Class<M> resolvableClass;
    private final MatchDbFilter<?, ?, ?> matchDbFilter;
    private final List<MatchMetaFilter<?, ?>> matchMetaFilters;
    private final MetaFilter<?, V> subMetaFilter;

    public <M1> AliasDbFilter(MetaFilter<? super M, V> metaFilter, Class<M> resolvableClass,
                              MatchDbFilter<?, ? super M1, ?> matchDbFilter, MetaFilter<M1, V> subMetaFilter) {
        this.metaFilter = metaFilter;
        this.resolvableClass = resolvableClass;
        this.matchDbFilter = matchDbFilter;
        this.matchMetaFilters = List.of();
        this.subMetaFilter = subMetaFilter;
    }

    public <M1, M2> AliasDbFilter(MetaFilter<? super M, V> metaFilter, Class<M> resolvableClass,
                                  MatchDbFilter<?, ? super M1, ?> matchDbFilter,
                                  MatchMetaFilter<M1, M2> matchMetaFilter,
                                  MetaFilter<M2, V> subMetaFilter) {
        this.metaFilter = metaFilter;
        this.resolvableClass = resolvableClass;
        this.matchDbFilter = matchDbFilter;
        this.matchMetaFilters = List.of(matchMetaFilter);
        this.subMetaFilter = subMetaFilter;
    }

    @Override
    public MetaFilter<? super M, V> getMetaFilter() {
        return metaFilter;
    }

    @Override
    public Class<M> getResolvableModelClass() {
        return resolvableClass;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        CoreFilterNode coreFilterNode = CoreFilterNode.create(subMetaFilter, operator, values);

        for (MatchMetaFilter<?, ?> matchMetaFilter : matchMetaFilters) {
            coreFilterNode = CoreFilterNode.match(matchMetaFilter, coreFilterNode);
        }
        return matchDbFilter.getCondition(FilterOperator.MATCH, coreFilterNode);
    }
}
