package ru.yandex.partner.core.filter.db;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public abstract class BaseDbFilter<M, T, V> implements DbFilter<M, V> {
    private final MetaFilter<? super M, V> metaFilter;
    private final Class<M> resolvableModelClass;
    private final Field<T> tableField;

    public BaseDbFilter(MetaFilter<? super M, V> metaFilter, Class<M> resolvableModelClass, Field<T> tableField) {
        this.metaFilter = metaFilter;
        this.resolvableModelClass = resolvableModelClass;
        this.tableField = tableField;
    }

    @Override
    public MetaFilter<? super M, V> getMetaFilter() {
        return metaFilter;
    }

    @Override
    public Class<M> getResolvableModelClass() {
        return resolvableModelClass;
    }

    protected Field<T> getField() {
        return tableField;
    }

    protected Condition getConditionInternal(FilterOperator operator, Collection<T> values) {
        return switch (operator) {
            case IN, EQUALS -> values.size() == 1
                    ? tableField.eq(values.iterator().next())
                    : tableField.in(values);
            case NOT_IN, NOT_EQUALS -> values.size() == 1
                    ? tableField.ne(values.iterator().next())
                    : tableField.notIn(values);
            default -> throw new IllegalArgumentException("Unsupported operator. FilterOperator = "
                    .concat(operator.name()).concat(" Class = ").concat(getClass().getName()));
        };
    }

}
