package ru.yandex.partner.core.filter.db;

import java.util.Collection;
import java.util.stream.Collectors;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class BooleanDbFilter<M> extends BaseDbFilter<M, Long, Boolean> {

    public BooleanDbFilter(MetaFilter<? super M, Boolean> metaFilter, Class<M> resolvableModelClass,
                           Field<Long> tableField) {
        super(metaFilter, resolvableModelClass, tableField);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Boolean> values) {
        return getConditionInternal(operator, values.stream().map(this::convert).collect(Collectors.toList()));
    }

    private Long convert(Boolean value) {
        return value != null && value
                ? 1L
                : 0L;
    }
}
